<?php

if (isset($public) || isset($semRefrescamento)) {
    include_once '../modelo/monitoramentoOperacoes.modelo.php';
} elseif (!isset($crr) && !isset($public) || !isset($semRefrescamento)) {
    include_once 'modelo/monitoramentoOperacoes.modelo.php';
}else {
    include_once 'controlador/monitoramentoOperacoes.modelo.php';
}

class ControladorMonitoramentoOperacoes
{
    // Função para adicionar uma nova operação no monitoramento
    static public function ctrAdicionarOperacao($operacao)
    {
        $ipDoUsuario = "";
        // Verificar se o IP foi definido no cabeçalho HTTP_X_FORWARDED_FOR (caso o usuário esteja atrás de um proxy) ou diretamente no REMOTE_ADDR
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP']; // IP vindo de um proxy compartilhado
            $ipDoUsuario = "Id vindo de um Proxy compartilhado: ".$_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR']; // IP vindo de um proxy
            $ipDoUsuario = "Id vindo de um Proxy: ".$_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR']; // IP direto do cliente
            $ipDoUsuario = "Id vindo de um Proxy: ".$_SERVER['REMOTE_ADDR'];
        }
        // Verificar se os campos "operacao" e "ipDoUsuario" foram preenchidos
        if (!empty($operacao) && !empty($ipDoUsuario)) {
            if (isset($_SESSION['NomeDoUsuario'])) {
                $operacao = $operacao." Id do Usuario:".$_SESSION['ID_usuario'].", Nome do Usuario: ".$_SESSION['NomeDoUsuario'];
            }else {
                $operacao = $operacao." Id do Usuario: Sem Id, Nome do Usuario: Sem nome";
            }
            // Array de dados a ser enviado para o modelo
            $dados = array(
                "operacao" => $operacao,
                "ipDoUsuario" => $ipDoUsuario
            );

            // Adicionar operação usando o modelo
            $resposta = ModeloMonitoramentoOperacoes::mdlAdicionarOperacao($dados);

            // Verificar a resposta e exibir uma mensagem adequada
            if ($resposta == "ok") {
                /* echo "
                <script>
                    Swal.fire({
                        position: 'top-end',
                        icon: 'success',
                        title: 'Operação registrada com sucesso!',
                        showConfirmButton: false,
                        timer: 3000
                    });
                </script>"; */
            } else {
                /* echo "
                <script>
                    Swal.fire({
                        position: 'top-end',
                        icon: 'error',
                        title: 'Erro: {$resposta}',
                        showConfirmButton: false,
                        timer: 5000
                    });
                </script>"; */
            }
        } else {
            // Exibir mensagem de erro se os campos estiverem vazios
            echo "
            <script>
                Swal.fire({
                    position: 'top-end',
                    icon: 'error',
                    title: 'Erro: Preencha todos os campos.',
                    showConfirmButton: false,
                    timer: 5000
                });
            </script>";
        }
    }

    // Função para listar todas as operações no monitoramento
    static public function ctrListarOperacoes()
    {
        // Usar o modelo para buscar todas as operações
        $resposta = ModeloMonitoramentoOperacoes::mdlListarOperacoes();
        return $resposta;
    }

    // Função para buscar operações por tipo de operação
    static public function ctrBuscarOperacoesPorOperacao($operacao)
    {
        // Usar o modelo para buscar operações com base na operação
        $resposta = ModeloMonitoramentoOperacoes::mdlBuscarOperacoesPorOperacao($operacao);
        return $resposta;
    }
}

?>

